/*
 * Decompiled with CFR 0.152.
 */
package leapTools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;

public class Preprocessor
extends Task {
    private static final String ALL_EXCLUDE_FILE_MARKER = "//#ALL_EXCLUDE_FILE";
    private static final String J2SE_EXCLUDE_FILE_MARKER = "//#J2SE_EXCLUDE_FILE";
    private static final String J2ME_EXCLUDE_FILE_MARKER = "//#J2ME_EXCLUDE_FILE";
    private static final String PJAVA_EXCLUDE_FILE_MARKER = "//#PJAVA_EXCLUDE_FILE";
    private static final String MIDP_EXCLUDE_FILE_MARKER = "//#MIDP_EXCLUDE_FILE";
    private static final String DOTNET_EXCLUDE_FILE_MARKER = "//#DOTNET_EXCLUDE_FILE";
    private static final String ALL_EXCLUDE_BEGIN_MARKER = "//#ALL_EXCLUDE_BEGIN";
    private static final String ALL_EXCLUDE_END_MARKER = "//#ALL_EXCLUDE_END";
    private static final String ALL_INCLUDE_BEGIN_MARKER = "/*#ALL_INCLUDE_BEGIN";
    private static final String ALL_INCLUDE_END_MARKER = "#ALL_INCLUDE_END*/";
    private static final String JAVA_EXCLUDE_BEGIN_MARKER = "//#JAVA_EXCLUDE_BEGIN";
    private static final String JAVA_EXCLUDE_END_MARKER = "//#JAVA_EXCLUDE_END";
    private static final String JAVA_INCLUDE_BEGIN_MARKER = "/*#JAVA_INCLUDE_BEGIN";
    private static final String JAVA_INCLUDE_END_MARKER = "#JAVA_INCLUDE_END*/";
    private static final String J2ME_EXCLUDE_BEGIN_MARKER = "//#J2ME_EXCLUDE_BEGIN";
    private static final String J2ME_EXCLUDE_END_MARKER = "//#J2ME_EXCLUDE_END";
    private static final String J2ME_INCLUDE_BEGIN_MARKER = "/*#J2ME_INCLUDE_BEGIN";
    private static final String J2ME_INCLUDE_END_MARKER = "#J2ME_INCLUDE_END*/";
    private static final String PJAVA_EXCLUDE_BEGIN_MARKER = "//#PJAVA_EXCLUDE_BEGIN";
    private static final String PJAVA_EXCLUDE_END_MARKER = "//#PJAVA_EXCLUDE_END";
    private static final String PJAVA_INCLUDE_BEGIN_MARKER = "/*#PJAVA_INCLUDE_BEGIN";
    private static final String PJAVA_INCLUDE_END_MARKER = "#PJAVA_INCLUDE_END*/";
    private static final String MIDP_EXCLUDE_BEGIN_MARKER = "//#MIDP_EXCLUDE_BEGIN";
    private static final String MIDP_EXCLUDE_END_MARKER = "//#MIDP_EXCLUDE_END";
    private static final String MIDP_INCLUDE_BEGIN_MARKER = "/*#MIDP_INCLUDE_BEGIN";
    private static final String MIDP_INCLUDE_END_MARKER = "#MIDP_INCLUDE_END*/";
    private static final String DOTNET_EXCLUDE_BEGIN_MARKER = "//#DOTNET_EXCLUDE_BEGIN";
    private static final String DOTNET_EXCLUDE_END_MARKER = "//#DOTNET_EXCLUDE_END";
    private static final String DOTNET_INCLUDE_BEGIN_MARKER = "/*#DOTNET_INCLUDE_BEGIN";
    private static final String DOTNET_INCLUDE_END_MARKER = "#DOTNET_INCLUDE_END*/";
    private static final String NODEBUG_EXCLUDE_BEGIN_MARKER = "//#NODEBUG_EXCLUDE_BEGIN";
    private static final String NODEBUG_EXCLUDE_END_MARKER = "//#NODEBUG_EXCLUDE_END";
    private static final String J2SE = "j2se";
    private static final String PJAVA = "pjava";
    private static final String MIDP = "midp";
    private static final String DOTNET = "DotNET";
    private static final int KEEP = 0;
    private static final int OVERWRITE = 1;
    private static final int REMOVE = 2;
    private boolean verbose = false;
    private int removedCnt = 0;
    private int modifiedCnt = 0;
    private String target;
    private String basedir;
    private String type;

    public void setTarget(String string) {
        this.target = string;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Object object;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        if (DOTNET.equalsIgnoreCase(this.type)) {
            stringArray = new String[]{ALL_EXCLUDE_BEGIN_MARKER, J2ME_EXCLUDE_BEGIN_MARKER, PJAVA_EXCLUDE_BEGIN_MARKER, DOTNET_EXCLUDE_BEGIN_MARKER};
            stringArray2 = new String[]{ALL_EXCLUDE_END_MARKER, J2ME_EXCLUDE_END_MARKER, PJAVA_EXCLUDE_END_MARKER, DOTNET_EXCLUDE_END_MARKER};
            stringArray3 = new String[]{ALL_INCLUDE_BEGIN_MARKER, ALL_INCLUDE_END_MARKER, J2ME_INCLUDE_BEGIN_MARKER, J2ME_INCLUDE_END_MARKER, PJAVA_INCLUDE_BEGIN_MARKER, PJAVA_INCLUDE_END_MARKER, DOTNET_INCLUDE_BEGIN_MARKER, DOTNET_INCLUDE_END_MARKER};
            stringArray4 = new String[]{ALL_EXCLUDE_FILE_MARKER, DOTNET_EXCLUDE_FILE_MARKER};
        } else if (MIDP.equalsIgnoreCase(this.type)) {
            stringArray = new String[]{ALL_EXCLUDE_BEGIN_MARKER, J2ME_EXCLUDE_BEGIN_MARKER, MIDP_EXCLUDE_BEGIN_MARKER, JAVA_EXCLUDE_BEGIN_MARKER};
            stringArray2 = new String[]{ALL_EXCLUDE_END_MARKER, J2ME_EXCLUDE_END_MARKER, MIDP_EXCLUDE_END_MARKER, JAVA_EXCLUDE_END_MARKER};
            stringArray3 = new String[]{ALL_INCLUDE_BEGIN_MARKER, ALL_INCLUDE_END_MARKER, J2ME_INCLUDE_BEGIN_MARKER, J2ME_INCLUDE_END_MARKER, MIDP_INCLUDE_BEGIN_MARKER, MIDP_INCLUDE_END_MARKER};
            stringArray4 = new String[]{ALL_EXCLUDE_FILE_MARKER, J2ME_EXCLUDE_FILE_MARKER, MIDP_EXCLUDE_FILE_MARKER};
        } else if (PJAVA.equalsIgnoreCase(this.type)) {
            stringArray = new String[]{ALL_EXCLUDE_BEGIN_MARKER, J2ME_EXCLUDE_BEGIN_MARKER, PJAVA_EXCLUDE_BEGIN_MARKER, JAVA_EXCLUDE_BEGIN_MARKER};
            stringArray2 = new String[]{ALL_EXCLUDE_END_MARKER, J2ME_EXCLUDE_END_MARKER, PJAVA_EXCLUDE_END_MARKER, JAVA_EXCLUDE_END_MARKER};
            stringArray3 = new String[]{ALL_INCLUDE_BEGIN_MARKER, ALL_INCLUDE_END_MARKER, J2ME_INCLUDE_BEGIN_MARKER, J2ME_INCLUDE_END_MARKER, PJAVA_INCLUDE_BEGIN_MARKER, PJAVA_INCLUDE_END_MARKER};
            stringArray4 = new String[]{ALL_EXCLUDE_FILE_MARKER, J2ME_EXCLUDE_FILE_MARKER, PJAVA_EXCLUDE_FILE_MARKER};
        } else if (J2SE.equalsIgnoreCase(this.type)) {
            stringArray = new String[]{ALL_EXCLUDE_BEGIN_MARKER, JAVA_EXCLUDE_BEGIN_MARKER};
            stringArray2 = new String[]{ALL_EXCLUDE_END_MARKER, JAVA_EXCLUDE_END_MARKER};
            stringArray3 = new String[]{ALL_INCLUDE_BEGIN_MARKER, ALL_INCLUDE_END_MARKER};
            stringArray4 = new String[]{ALL_EXCLUDE_FILE_MARKER, J2SE_EXCLUDE_FILE_MARKER};
        } else {
            object = this.type.toUpperCase();
            stringArray = new String[]{"//#" + (String)object + "_EXCLUDE_BEGIN"};
            stringArray2 = new String[]{"//#" + (String)object + "_EXCLUDE_END"};
            stringArray3 = new String[]{"/*#" + (String)object + "_INCLUDE_BEGIN", "#" + (String)object + "_INCLUDE_END*/"};
            stringArray4 = new String[]{"//#" + (String)object + "_EXCLUDE_FILE"};
        }
        if (this.basedir != null) {
            object = new File(this.basedir);
            if (!((File)object).isDirectory()) throw new BuildException("Error: " + this.basedir + " is not a directory.");
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir((File)object);
            directoryScanner.setIncludes(new String[]{"**/*.java"});
            directoryScanner.scan();
            String[] stringArray5 = directoryScanner.getIncludedFiles();
            System.out.println("Preprocessing " + stringArray5.length + " files.");
            int n = 0;
            while (n < stringArray5.length) {
                this.execute(((File)object).getPath() + "/" + stringArray5[n], stringArray, stringArray2, stringArray3, stringArray4);
                ++n;
            }
            System.out.println("Modified " + this.modifiedCnt + " files.");
            System.out.println("Removed  " + this.removedCnt + " files.");
            return;
        } else {
            this.execute(this.target, stringArray, stringArray2, stringArray3, stringArray4);
        }
    }

    private void execute(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws BuildException {
        if (this.verbose) {
            System.out.println("Preprocessing file " + string + " (type: " + this.type + ")");
        }
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            File file2 = File.createTempFile(file.getName(), "tmp", file.getParentFile());
            FileWriter fileWriter = new FileWriter(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n = this.preprocess(bufferedReader, bufferedWriter, stringArray, stringArray2, stringArray3, stringArray4);
            bufferedReader.close();
            bufferedWriter.close();
            switch (n) {
                case 1: {
                    if (!file.delete()) {
                        System.out.println("Can't overwrite target file with preprocessed file");
                        throw new BuildException("Can't overwrite target file " + this.target + " with preprocessed file");
                    }
                    file2.renameTo(file);
                    if (this.verbose) {
                        System.out.println("File " + file2.getName() + " modified.");
                    }
                    ++this.modifiedCnt;
                    break;
                }
                case 2: {
                    if (!file.delete()) {
                        System.out.println("Can't delete target file");
                        throw new BuildException("Can't delete target file " + this.target);
                    }
                    if (!file2.delete()) {
                        System.out.println("Can't delete temporary preprocessed file " + file2.getName());
                        throw new BuildException("Can't delete temporary preprocessed file " + file2.getName());
                    }
                    if (this.verbose) {
                        System.out.println("File " + file2.getName() + " removed.");
                    }
                    ++this.removedCnt;
                    break;
                }
                case 0: {
                    if (!file2.delete()) {
                        System.out.println("Can't delete temporary preprocessed file " + file2.getName());
                        throw new BuildException("Can't delete temporary preprocessed file " + file2.getName());
                    }
                    break;
                }
                default: {
                    throw new BuildException("Unexpected preprocessing result for file " + file2.getName());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException(exception.getMessage());
        }
    }

    private int preprocess(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws IOException {
        String string = null;
        boolean bl = false;
        int n = 0;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            String string3 = string.trim();
            if (this.isMarker(string3, stringArray4)) {
                return 2;
            }
            if (!bl) {
                if (this.isMarker(string3, stringArray)) {
                    n = 1;
                    bl = true;
                    string2 = this.getExcludeEndMarker(string3, stringArray2);
                    continue;
                }
                if (!this.isMarker(string3, stringArray3)) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    continue;
                }
                n = 1;
                continue;
            }
            if (!string3.startsWith(string2)) continue;
            bl = false;
            string2 = null;
        }
        return n;
    }

    private boolean isMarker(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String getExcludeEndMarker(String string, String[] stringArray) {
        int n = string.indexOf("BEGIN");
        String string2 = string.substring(0, n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith(string2)) {
                return stringArray[n2];
            }
            ++n2;
        }
        return null;
    }
}

